<?php

// Definiowanie staych cigw znakw oraz zmiennych pozycjonowania.
define("CASE_CATEGORY",  "Category");
define("CASE_LIST",      "List");
define("CASE_OBJECTIVE", "Objective");
define("MARGIN",         50);
define("PAGE_HEIGHT",    792);
define("PAGE_WIDTH",     612);
define("TAB",            25);
define("VERT_SPACING",   14);

// Definiowanie kilku przydatnych funkcji.
function drawHR($res) {
   $xpos = MARGIN;
   $ypos = pdf_get_value($res, "texty", 0) - VERT_SPACING;
   pdf_moveto($res, $xpos, $ypos);
   pdf_lineto($res, PAGE_WIDTH - MARGIN, $ypos);
   pdf_closepath($res);
   pdf_fill($res);
   $ypos = pdf_get_value($res, "texty", 0) - (VERT_SPACING * 2);
}

function pdflib_show($res, $text, $type) {
   $font = pdf_findfont($res, "Times-Roman", "winansi", 0);
   $xpos = MARGIN;
   $ypos = pdf_get_value($res, "texty", 0) - VERT_SPACING;

   switch ($type) {
   case CASE_CATEGORY:
      $font = pdf_findfont($res, "Times-Bold", "winansi", 0);
      $ypos = pdf_get_value($res, "texty", 0) - (VERT_SPACING * 3);
      break;
   case CASE_LIST:
      $xpos = MARGIN + TAB;
      $text = "* " . $text;
      break;
   case CASE_OBJECTIVE:
      $font = pdf_findfont($res, "Times-Italic", "winansi", 0);
      $xpos = MARGIN + TAB;
      $text = "\"" . $text . "\"";
      break;
   }
   pdf_setfont($res, $font, 12.0);
   pdf_show_xy($res, $text, $xpos, $ypos);
   return;
}

// Tworzenie zasobu.
$pdf = pdf_new();
if (!pdf_open_file($pdf, "")) {
   die("Bd: Bd: Nie mona otworzy pliku!");
}

// Pobieramy z bazy danych informacje do nagwkw.
mysql_connect("localhost", "resume_user", "resume_pw");
mysql_select_db("resume");
$sql = "SELECT * FROM biography WHERE OID = 0";
$result = mysql_query($sql);
$row = mysql_fetch_array($result, MYSQL_ASSOC);
$name = $row["NameFirst"] . " " . $row["NameLast"];

// Dane dokumentu.
pdf_set_info($pdf, "Author", $name . " <" . $row["Email"] . ">");
pdf_set_info($pdf, "Title", "Resume - " . $name);
pdf_set_info($pdf, "Subject", "Aplikacja o prac na stanowsku" .
             $row["DesiredPosition"] . ".");

// Zabawy ze sowami kluczowymi.
$keywords = split(" ", $row["DesiredPosition"]);
$morewords = "";
foreach($keywords as $keyword) {
   $morewords = $morewords . $keyword . ", ";
}
pdf_set_info($pdf, "Keywords", "Resume, " . $morewords . "apache, mysql, php, 
pdf");

// Pocztek strony PDF. -- Stron mona rozpocz w dowolnym momencie
// po utworzeniu samego zasobu PDF.
pdf_begin_page($pdf, PAGE_WIDTH, PAGE_HEIGHT);

// Wypisujemy nazwisko.
$font = pdf_findfont($pdf, "Times-Bold", "winansi", 0);
pdf_setfont($pdf, $font, 14.0);
$stringwidth = pdf_stringwidth($pdf, $name, $font, 14.0);
$xpos = (PAGE_WIDTH / 2) - ($stringwidth / 2);
pdf_show_xy($pdf, $name, $xpos, 700);
$xpos = pdf_get_value($pdf, "textx", 0);
$ypos = pdf_get_value($pdf, "texty", 0) - VERT_SPACING;

// Wypisujemy informacje kontaktowe.
$font = pdf_findfont($pdf, "Times-Roman", "winansi", 0);
pdf_setfont($pdf, $font, 12.0);
$headerdata = array($row["Address"],
                    $row["City"] . ", " . $row["State"] . " " . $row["ZipCode"],
        $row["Phone"],
        $row["Email"]);
foreach ($headerdata as $data) {
   $stringwidth = pdf_stringwidth($pdf, $data, $font, 12.0);
   $xpos = (PAGE_WIDTH / 2) - ($stringwidth / 2);
   $ypos = pdf_get_value($pdf, "texty", 0) - VERT_SPACING;
   pdf_show_xy($pdf, $data, $xpos, $ypos);
}

// Wypisujemy kategorie.
$sql = "SELECT * FROM items WHERE BIOGRAPHY_OID = 0";
$result = mysql_query($sql);
$prevCategory = "";
while($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
   $curCategory = $row["Category"];
   if (strcmp($prevCategory, $curCategory) != 0) {
      drawHR($pdf);
      pdflib_show($pdf, $row["Category"], CASE_CATEGORY);
   }
   $prevCategory = $row["Category"];
   if (strcmp($row["Category"], "Career Objective") == 0) {
      pdflib_show($pdf, $row["Description"], CASE_OBJECTIVE);
   } else {
      pdflib_show($pdf, $row["Description"], CASE_LIST);
   }
}

// Zakoczenie dokumentu i przesanie go do przegldarki.
pdf_end_page($pdf);
pdf_close($pdf);
$buf = pdf_get_buffer($pdf);
$len = strlen($buf);
header("Content-type: application/pdf");
header("Content-Length: $len");
header("Content-Disposition: inline; filename=resume.pdf");
print $buf;

// Czyszczenie!
mysql_close();
$pdf = 0;

?>
